%
% Elliptic_Unscaled_Values.m
%
% Calculates positive-value labels for upper curve of elliptic function
% nomogram. For an explanation, please see the essay "A Zoomorphic Nomogram"
% at http://www.myreckonings.com/wordpress

cd('C:\temp')

min_value = -40;
max_value = 40;

fid=0;
[fid,message] = fopen('elliptic_unscaled_g2_1200_g3_-8500.rtf', 'w');
if fid == -1
    disp(message)
else
    g2 = 1200.0;
    g3 = -8500.0;
    h=@(x) (1.0 ./ sqrt(4*x.^3-g2*x-g3));
    for xvalue = min_value:max_value
        result = quad(h,xvalue,10000000000) % Numerical integration
        fprintf(fid,'%d %5.4f %+5.4fi\n',xvalue,real(result),imag(result));
    end
    
    % Calculate value for the point where y=0 at end of elliptic curve.
    xvalue = -20.138 
    result = quad(h,xvalue,10000000000) % Numerical integration
    fprintf(fid,'%d %5.4f %+5.4fi\n',xvalue,real(result),imag(result));

    % Calculate value for x=-19.7 to fill in the large gap.
    xvalue = -19.7
    result = quad(h,xvalue,10000000000) % Numerical integration
    fprintf(fid,'%d %5.4f %+5.4fi\n',xvalue,real(result),imag(result));
    
end

status = fclose(fid);
disp(status)

